% generate point pairs for plotting
a_comp = [0 15];
a_temp = [0 170];
b_comp = [0 15];
b_temp = [640 170];
c_comp = [0 40];
c_temp = [640 170];
d_comp = [40 100];
d_temp = [170 725];
e_comp = [90 100];
e_temp = [170 725];
f_comp = [90 100];
f_temp = [170 0];
g_comp = [15 90];
g_temp = [170 170];
h_comp = [100 100];
h_temp = [725 0];

% choose a point to check
x_comp = input('Please enter the percent of material B: ');        % percent of material B included
x_temp = input('Please enter the temperature of the material: ');  % temperature of the material

% generate the plot
plot(a_comp, a_temp, 'k-', b_comp, b_temp, 'k-', c_comp, c_temp, 'k-', d_comp, d_temp, 'k-', e_comp, e_temp, 'k-', f_comp, f_temp, 'k-', g_comp, g_temp, 'k-', h_comp, h_temp, 'k-', x_comp, x_temp, 'r*');
xlabel('Percent composition of material B');
ylabel('Temperature ^oC');
title('Phase diagram for composite of materials A and B');

% determine the phase of the composite material
if (x_temp-c_temp(2)) > ((c_temp(2)-c_temp(1))/(c_comp(2)-c_comp(1))*(x_comp-c_comp(2))) && (x_temp-d_temp(2)) > ((d_temp(2)-d_temp(1))/(d_comp(2)-d_comp(1))*(x_comp-d_comp(2)))
    fprintf('The material is entirely liquid.\n');
elseif (x_temp-b_temp(2)) <= ((b_temp(2)-b_temp(1))/(b_comp(2)-b_comp(1))*(x_comp-b_comp(2))) && (x_temp-a_temp(2)) > ((a_temp(2)-a_temp(1))/(a_comp(2)-a_comp(1))*(x_comp-a_comp(2)))
    fprintf('The material is made of solid A.\n');
elseif (x_temp-e_temp(2)) <= ((e_temp(2)-e_temp(1))/(e_comp(2)-e_comp(1))*(x_comp-e_comp(2))) && (x_temp-f_temp(2)) > ((f_temp(2)-f_temp(1))/(f_comp(2)-f_comp(1))*(x_comp-f_comp(2)))
    fprintf('The material is made of solid B.\n');
elseif (x_temp-b_temp(2)) > ((b_temp(2)-b_temp(1))/(b_comp(2)-b_comp(1))*(x_comp-b_comp(2))) && (x_temp-c_temp(2)) <= ((c_temp(2)-c_temp(1))/(c_comp(2)-c_comp(1))*(x_comp-c_comp(2))) && x_temp > 170
    fprintf('The material is made of solid A and liquid B.\n');
elseif (x_temp-e_temp(2)) > ((e_temp(2)-e_temp(1))/(e_comp(2)-e_comp(1))*(x_comp-e_comp(2))) && (x_temp-d_temp(2)) <= ((d_temp(2)-d_temp(1))/(d_comp(2)-d_comp(1))*(x_comp-d_comp(2))) && x_temp > 170
    fprintf('The material is made of solid B and liquid A.\n');
else
    fprintf('The material is entirely solid.\n');
end